function A = rand_doubletcons_bin(A,i)
%RAND_DOUBLETCONS_BIN Generate randomly rewired adjacency matrix with
%identical out-degree distribution to A, preserving doublet counts
%   A should be a square adjacency matrix

% A = logical(A);
% Clear self loops
A(logical(eye(size(A)))) = 0;

R = (A>0) & (A'>0);
O = (A>0) & ~(A'>0);

[iA jA] = find(A);
[iR jR] = find(R);
[iO jO] = find(O);
mA = numel(iA);
mR = numel(iR);
mO = numel(iO);

nIters = i * mA;
t1 = 0;
t2 = 0;
for kk = 1:nIters
    
%     fprintf('mA: %u, mR: %u, mO: %u\n',mA,mR,mO);
%     tic;
    
    % Pick a random edge
    idx1 = randsample(mA,1);
    
    a = iA(idx1);
    b = jA(idx1);
    
    % Determine if this is a reciprocal edge or one-directional
    if O(a,b)   % One-directional case
        while 1
            % Pick another one-directional edge
            idx2 = randsample(mO,1);
            c = iO(idx2);
            d = jO(idx2);
            while length(unique([a b c d])) ~= 4   % make sure all edges are different
                idx2 = randsample(mO,1);    
                c = iO(idx2);
                d = jO(idx2);
            end
            
            % Rewiring condition - make sure we are not creating edges
            % that already exist or creating loops
            if ~any([A(a,d),A(d,a),A(c,b),A(b,c)])
%                 fprintf('One directional - a: %u, b: %u, c: %u, d: %u\n',a,b,c,d);
                % Switch edges
                A(a,d) = A(a,b); A(a,b) = 0;
                A(c,b) = A(c,d); A(c,d) = 0;
                O(a,d) = true; O(a,b) = false;
                O(c,b) = true; O(c,d) = false;
                % jA(idx1) = d; jO(idx1) = d;
                % jA(idx2) = b; jO(idx2) = b;
                break;
            end
        end
    elseif R(a,b) %Reciprocal case
        cnt = 0;
        while 1
            
            % Pick another reciprocal edge
            idx2 = randsample(mR,1);
            c = iR(idx2);
            d = jR(idx2);
            while length(unique([a b c d])) ~= 4
                idx2 = randsample(mR,1);    % make sure all edges are different
                c = iR(idx2);
                d = jR(idx2);
            end
            
            % Rewiring condition - make sure we are not creating edges
            % that already exist or erasing other edges
            if ~any([A(a,d), A(d,a), A(c,b), A(b,c)])
%                 fprintf('Reciprocal - a: %u, b: %u, c: %u, d: %u\n',a,b,c,d);
                % Switch edges
                A(a,d) = A(a,b); A(d,a) = A(d,c); 
                A(c,b) = A(c,d); A(b,c) = A(b,a); 
                A(a,b) = 0; A(b,a) = 0; A(c,d) = 0; A(d,c) = 0;
                R(a,d) = true; R(d,a) = true; R(a,b) = false; R(b,a) = false;
                R(c,b) = true; R(b,c) = true; R(c,d) = false; R(d,c) = false;
                % jA(idx1) = d; iA(idx2) = a; jR(idx1) = d; iR(idx2) = a;
                % jA(idx2) = b; iA(idx1) = c; jR(idx2) = b; iR(idx1) = d;
                break;
            end
            if cnt>100, break; end    % Lame fix to prevent infinite looping if there are no possible reciprocal rewirings
            % Need to pick a new initial random reciprocal edge to
            % prevent infinite looping
%             idx1 = randsample(mR,1);
%             a = iR(idx1);
%             b = jR(idx1);
            
            cnt = cnt+1;
            
        end
    end
%     t1 = t1+toc;
%     tic
    
%     R = A & A';
%     O = A & ~(A');
    
    [iA jA] = find(A);
    [iR jR] = find(R);
    [iO jO] = find(O);
%     fprintf('%u\n',full(sum(sum(A))));
%     mA = numel(iA);
%     mR = numel(iR);
%     mO = numel(iO);
%     t2 = t2+ toc;
end
% fprintf('t1: %f, t2: %f\n',t1,t2);
end



